// azip16.h
//
// C/C++ header file for addZIP compression libraries
//
// Copyright  1995,1996 Stephen Darlington. All rights reserved.

#ifndef _AZIP_H_
#define _AZIP_H_

#ifdef __cplusplus
extern "C"
{
#endif
int WINAPI _export addZIP(void);
int WINAPI _export addZIP_ArchiveName(LPSTR);
int WINAPI _export addZIP_Delete(int);
int WINAPI _export addZIP_Encrypt(LPSTR);
int WINAPI _export addZIP_Exclude(LPSTR);
int WINAPI _export addZIP_ExcludeListFile(LPSTR);
int WINAPI _export addZIP_GetLastError(void);
int WINAPI _export addZIP_GetLastWarning(void);
int WINAPI _export addZIP_Include(LPSTR);
int WINAPI _export addZIP_IncludeListFile(LPSTR);
int WINAPI _export addZIP_Overwrite(int);
int WINAPI _export addZIP_Register(LPSTR, DWORD);
int WINAPI _export addZIP_Recurse(int);
int WINAPI _export addZIP_SaveStructure(int);
int WINAPI _export addZIP_SetCompressionLevel(int);
int WINAPI _export addZIP_SetParentWindowHandle(HWND);
int WINAPI _export addZIP_SetWindowHandle(HWND);
int WINAPI _export addZIP_Store(LPSTR);
int WINAPI _export addZIP_UseLFN(int);
int WINAPI _export addZIP_View(int);
#ifdef __cplusplus
}
#endif

// constants for addZIP_SetCompressionLevel
#define COMPRESSION_NONE 0
#define COMPRESSION_MINIMUM 1
#define COMPRESSION_NORMAL 2
#define COMPRESSION_MAXIMUM 3

// constants for addZIP_SaveStructure
#define SAVE_FILENAME_ONLY 0
#define SAVE_RELATIVE_PATH 1
#define SAVE_ABSOLUTE_PATH 2

// constants for addZIP_Overwrite(...)
#define OVERWRITE_QUERY 10
#define OVERWRITE_ALL 11
#define OVERWRITE_NONE 12

#endif
